if (!window.__LIRAX_LOADER_INITIALIZED__) {
   
    class LiraXLoader {
        #token = null;
        #windowId = null;
        #domain = 'lira2r.voip.com.ua';
        #socketUrl = 'wss://lira0.lirax.net:1887/';
        #initialized = false;

        constructor() {
            
            window.__LIRAX_LOADER_INITIALIZED__ = true;
            this.#initialized = true;

            this.#extractToken();
            this.#injectScript();
        }

        #extractToken() {
            const currentScript = document.currentScript;
            if (!currentScript) {
                console.warn('⚠️ currentScript is null');
                return;
            }

            const queryString = currentScript.src.split('?')[1];
            if (!queryString) {
                console.warn('⚠️ No query string found in script URL');
                return;
            }

            const params = new URLSearchParams(queryString);
            this.#token = params.get('token') || '0';
            this.#windowId = params.get('windowId') || '0';
        }

        #injectScript() {
            if (!this.#token || this.#token === '0') {
                console.warn('⚠️ Token is missing or invalid');
            }

            const remoteUrl = `https://${this.#domain}/chrome_ext_integrations/index.php?route=general&token=${encodeURIComponent(this.#token)}&windowId=${this.#windowId}&socketUrl=${this.#socketUrl}`;
            const script = document.createElement('script');

            script.src = remoteUrl;
            script.type = 'text/javascript';
            script.async = true;

            script.onload = () => console.log('✅ Loaded:', remoteUrl);
            script.onerror = () => console.error('❌ Error loading:', remoteUrl);

            document.head.appendChild(script);
        }
    }

    new LiraXLoader();

} else {
    console.log('ℹ️ Already initialized');
}