let socket = null;
let token = null;
let timer = null;
let autoAcceptCallStatus = false;
let redirectCallPhoneNumber = '';
let redirectCallStatus = 0;
let wsStatus = 0;
let wsTimeot = 5000;
let statcount = -1;
let startTime = '';
let isFunctionRun = false;
let socketUrl = 'wss://lira0.lirax.net:1887/';
const socketUrldef = 'wss://lira0.lirax.net:1887/';
let timestamp = Date.now();
let audioval = `audio${timestamp}`;
let extentionPhoneStatus = 'on';
let callType = '';
let phoneBackgroundClass = '';
let last_level = 0;
let useNotification = true;
let debugLevel = 1;
let lastTimeInSeconds = 0;
let lastPong = 0;
let duration = 0;
let showprogress = false;
let wait4sdp = true;
let scriptingDomain = '';

async function getSessionStorage(key) {
    return new Promise((resolve, reject) => {
        chrome.storage.session.get([key], (result) => {
            if (chrome.runtime.lastError) {
                return reject(chrome.runtime.lastError);
            }
            resolve(result[key]);
        });
    });
}

async function setSessionStorage(key, value) {
    return new Promise((resolve, reject) => {
        chrome.storage.session.set({ [key]: value }, () => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
            } else {
                resolve();
            }
        });
    });
}

async function getChromeStorage(key) {
    return new Promise((resolve, reject) => {
        chrome.storage.local.get([key], (result) => {
            if (chrome.runtime.lastError) {
                return reject(chrome.runtime.lastError);
            }
            resolve(result[key]);
        });
    });
}

async function setChromeStorage(key, value) {
    return new Promise((resolve, reject) => {
        chrome.storage.local.set({ [key]: value }, () => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
            } else {
                resolve();
            }
        });
    });
}

async function loadDefaults() {

    try {
        token = await getChromeStorage('token');
    } catch (error) {
        console.error('Error loading token:', error);
    }

    try {
        autoAcceptCallStatus = await getChromeStorage('autoAcceptCallStatus');
    } catch (error) {
        console.error('Error loading autoAcceptCallStatus:', error);
    }

    try {
        redirectCallStatus = await getChromeStorage('redirectCallStatus');
    } catch (error) {
        console.error('Error loading redirectCallStatus:', error);
    }

    try {
        redirectCallPhoneNumber = await getChromeStorage('redirectCallPhoneNumber');
    } catch (error) {
        console.error('Error loading autoAcceptCallStatus:', error);
    }

    try {
        extentionPhoneStatus = await getChromeStorage('extentionPhoneStatus');
        extentionPhoneStatus = extentionPhoneStatus || 'on'
    } catch (error) {
        console.error('Error loading autoAcceptCallStatus:', error);
    }
    
    if (token != null && token.length > 1 && extentionPhoneStatus == 'on') {
        setLogo();
    } else {
        setLogo('gray');
    }
    
    try {
        useNotification = await getChromeStorage('useNotification');
        useNotification = useNotification === undefined ? true : useNotification
    } catch (error) {
        console.error('Error loading useNotification:', error);
    }

    try {
        last_level = await getChromeStorage('last_level');
        last_level = last_level || '0'
    } catch (error) {
        console.error('Error loading autoAcceptCallStatus:', error);
    }

    StoreCalls.loadCallsData();
    Base.clearForCall();
}

function chromeSend (target, command, data = null) {
    chrome.runtime.sendMessage({
        target: target,
        command: command,
        data: data
    }, (response) => {if (chrome.runtime.lastError) { /* message didn't delivered */}});
}

function setLogo (color = '') {
    var  extensionId = chrome.runtime.id;

    if (color == 'red') color = '_red';
    else if (color == 'gray') color = '_gray';

    const iconPath = `chrome-extension://${extensionId}/assets/icons/logo${color}.png`;

    chrome.action.setIcon({ path: iconPath }).catch((error) => {
        console.error("Error setting icon:", error);
    });
}


async function openWindow () {

    if (token == null || token == '' || extentionPhoneStatus == 'off') return;

    chromeSend(audioval, 'closeWindow');
    timestamp = Date.now();
    audioval = `audio${timestamp}`;

    let device = await getChromeStorage('device');

    chrome.windows.create({
        url: chrome.runtime.getURL(`audio.html?value=${encodeURIComponent(audioval)}&deviceId=${device}`),
        type: "popup",
        width: 350,
        height: 250
    });
}

async function checkConnection() {

    if (!token) return;

    if (isFunctionRun || extentionPhoneStatus == 'off') {
        return;
    }

    if (statcount == -1) {

        openWindow();
        statcount++;

        setTimeout(() => {
            isFunctionRun = false;
            checkConnection();
        }, 2100);

        return;
    }

    isFunctionRun = true;

    startTime = new Date();

    chrome.runtime.sendMessage({
        target: audioval,
        command: 'ping'
    }, (response) => {
        if (chrome.runtime.lastError) {

            if (lastTimeInSeconds != Math.floor(Date.now() / 1000)) {
                statcount++;
                lastTimeInSeconds = Math.floor(Date.now() / 1000);
            }

        } else {
            statcount = 0;
        }
    });

    if (statcount >= 4) {
        try {
            lastPong = await getSessionStorage('pong');
        } catch (error) {
            console.error('Error fetching pong:', error);
        }
        
        if (Math.floor(Date.now() / 1000) - lastPong > 40) openWindow();

        statcount = 0;
    }

    setTimeout(() => {
        isFunctionRun = false;
        checkConnection();
    }, 11200);
}


function acceptCall () {

    if (callType != 'incomming' || phoneBackgroundClass != 'orange') return;

    SendNotify.close();
    SendNotify.notificationId = null;

    setTimeout(() => {
        duration = 1;
        showprogress = true;
        SendNotify.send('hungUp');
    }, 1000);

    socketSend({"accept":{"line":"1"}});

    chromeSend(audioval, 'stopSound');
    chromeSend('phone', 'setGreenStatus', {line: 1});

    setChromeStorage('phoneBackgroundClass', phoneBackgroundClass = 'green');
    chrome.action.setBadgeBackgroundColor({ color: '#23c82359' });
    StoreCalls.setLine(1).searchByPhone(0).updateOrAddCall({success: true});
    Base.startCountDuration(true);

}

function finishCall (line) {
    socketSend({"info": "bye", "msg_values": {"line": line}});
    clearStorage(line).then(() => {
        webrtcClose();
    });
    Base.clearForCall();
    chromeSend(audioval, 'playFail');
}

function socketSend (data) {

    if (extentionPhoneStatus == 'off') {
        console.warn('phone is off')
        return false;
    }
    if (!token) {
        loadDefaults();
        return false;
    }
    if (socket == null) {
        console.error('socket is null')
        return false;
    }
    if (socket.readyState !== WebSocket.OPEN) {
        console.error('socket have wrong state')
        return false;
    }

    socket.send(JSON.stringify(data));
    return true;
}

function startCall (phoneNumber, line, typeCall, message = '') {
    
    if (line == 1) {
        setChromeStorage('phoneBackgroundClass', phoneBackgroundClass = 'orange');
        setChromeStorage('phoneNumber', phoneNumber);
    } else if (line == 2) {
        setChromeStorage('phoneBackgroundClass2', phoneBackgroundClass = 'orange');
        setChromeStorage('phoneNumber2', phoneNumber);
    }

    duration = 0;
    showprogress = true;

    if ((message != '' && typeCall == 'incomming') || typeCall == 'outgoingByChromeExtIntegration') {

        let providerNumberAndName = Base.providerNumber + ' : ' + Base.providerName;
        setChromeStorage('contactName', Base.contactName);
        setChromeStorage('providerNumber', providerNumberAndName);
        
        SendNotify.send('accept');

        if (typeCall == 'incomming') chromeSend(audioval, 'playSound');

        try {
            chrome.action.openPopup()
            .then(() => {
                chromeSend('phone', 'showPhone', {incoming_number: phoneNumber});
                chromeSend('phone', 'setProvider', {line: 1, contactName: Base.contactName, providerNumber: providerNumberAndName});
            }).catch((error) => { // if popup already open
                chromeSend('phone', 'showPhone', {incoming_number: phoneNumber});
                chromeSend('phone', 'setProvider', {line: 1, contactName: Base.contactName, providerNumber: providerNumberAndName});
            });

        } catch (error) {
            console.warn('Couldn\'t open openPopup()', error);
        }

        if (autoAcceptCallStatus == true) {
            setTimeout(() => {
    		    SendNotify.close();
                acceptCall();
            }, 4000);
        }
    } else {
        Base.phoneNumber = phoneNumber;
        SendNotify.send('hungUp'); // for outgoing
    }

    chromeSend('phone', 'setOrangeStatus', {line: line, phoneNumber: phoneNumber});
    Base.setBadge('Call');

}




async function connectWebSocket() {

    if (wsStatus > 0) return;

    wsStatus = 1;
    if (wsStatus < 2 && !token) {
        try {
            token = await getChromeStorage('token');
            console.log('on websock token: ', token);
        } catch (error) {
            console.error('Error loading token:', error);
        }
    }

    if (!token || extentionPhoneStatus == 'off') {
        wsStatus = 0;
        return;
    }

    try {
        last_level = await getChromeStorage('last_level');
        last_level = last_level || '0'
    } catch (error) {
        last_level = 0;
    }

    chromeSend(audioval, 'closeWebRTC');
    socket = new WebSocket(typeof socketUrl !== 'undefined' ? socketUrl : socketUrldef);
    wsTimeot = 5000;
    wsStatus = 2;

    setLogo('red');
    socket.onopen = async () => {

        const authMessage = {
            connect: {
                login: 'chrome_ext',
                password: token,
                phone_number: 'chrome_ext',
                last_level: last_level,
            },
        };
        socketSend(authMessage);

        setTimeout(() => {
            if (wsStatus != 3) {
                socket.close();
                wsStatus = 0;
                connectWebSocket();
            }
        }, 10000);

        clearStorage(1);
        clearStorage(2);
        Base.setBadge('clear');
        
    };

    socket.onmessage = async (event) => {
        const message = JSON.parse(event.data);

        if (message.msg_type === 'sdp' || message.msg_type === 'ice') {
            chromeSend(audioval, 'sdp', message);
        } else if (message.msg_type === 'reconnect') {

            if (message.msg_values.line != undefined && message.msg_values.line != 1 && message.msg_values.line != 2) return;

            socketUrl = message.msg_values.url;
            wsTimeot = 0;
            if (socket && socket.readyState !== WebSocket.CLOSED) {
                wsStatus = 0;
                socket.close();

            } else {
                connectWebSocket();
            }

            return;

        } else if (message.msg_type === 'ping') {
            socketSend({ "pong": "pong" });

            if (token != null && token.length > 1 && extentionPhoneStatus == undefined) {
                extentionPhoneStatus ='on';
                setChromeStorage('extentionPhoneStatus', 'on');
                setLogo();
            }

        } else if (message.msg_type == 'invited') {
            Base.phoneNumber = message.msg_values.ani_num;

            socketSend({"ringing":{"id":message.msg_values.id,"line":"1"}});

            if (message.msg_values.incoming_number != undefined && message.msg_values.contact_name != undefined) {
                
                Base.providerNumber = message.msg_values.incoming_number;
                Base.providerName = message.msg_values.incoming_number_name;
                Base.contactName = message.msg_values.contact_name;

                if (StoreCalls.searchByPhone(Base.phoneNumber).found) {
                    StoreCalls.searchByPhone(Base.phoneNumber).updateOrAddCall({date: StoreCalls.getDate(), type: 'incomming', success: false});
                } else {
                    StoreCalls.searchByPhone(Base.phoneNumber).updateOrAddCall({phone: Base.phoneNumber, name: message.msg_values.contact_name, type: 'incomming'});
                }
            }

            callType = 'incomming';
            startCall(Base.phoneNumber, 1, callType, message);
            
        } else if (message.msg_type == 'byed') {
            chromeSend(audioval, 'stopSound');
            chromeSend(audioval, 'playFail');
            clearStorage(message.msg_values.line).then(() => {
                webrtcClose();
            });

            SendNotify.close();

            if (StoreCalls.callsData[0]?.success == false) {
                Base.setShowLostLabel(true);
                Base.setBadge('Lost');
            }

        } else if (message.msg_type == 'call_out') {
    		SendNotify.close();
	        acceptCall();
        } else if (message.msg_type == 'accepted') {
            let line = message.msg_values.line;
            chromeSend('phone', 'setGreenStatus', {line: line});
            if (line == 1) {
                setChromeStorage('phoneBackgroundClass', phoneBackgroundClass = 'green');
                setTimeout(() => {
                    duration = 1;
                    SendNotify.send('hungUp');
                }, 1000);
            }
            if (line == 2) {
                setChromeStorage('phoneBackgroundClass2', phoneBackgroundClass = 'green');
            }
            chrome.action.setBadgeBackgroundColor({ color: '#23c82359' }); // green

            StoreCalls.setLine(line).searchByPhone(0).updateOrAddCall({success: true});

            Base.startCountDuration(true);

        } else if (message.msg_type == 'callme') {

            if (redirectCallStatus == 1 && redirectCallPhoneNumber === '') {
                const now = new Date();
                const time = `${now.getHours()}:${now.getMinutes()}:${now.getSeconds()}.${now.getMilliseconds()}`;

            } else if (redirectCallStatus == 1 && redirectCallPhoneNumber !== '') {
                socketSend({"callout":redirectCallPhoneNumber});
                acceptCall();
                return;
            }
	        wait4sdp = true;
            setTimeout(() => {
                if (wait4sdp) {
                    openWindow();
                    wait4sdp = false;
                }
            }, 3000);
            chromeSend(audioval, 'sendSDP');
        } else if (message.msg_type == 'media_accept') {
            setLogo();
            wsStatus = 3;
        } else if (message.msg_type == 'user_reset') {
            Log.add('user_reset');
            extentionPhoneStatus = 'off';
            setChromeStorage('extentionPhoneStatus', 'off');
            setLogo('gray');
    	    socketUrl = socketUrldef;
        } else if (message.msg_type == 'contact_name') {
	    

            if (message.msg_values.line == 1) {
                Base.contactName = message.msg_values.contact_name;
                setChromeStorage('contactName', message.msg_values.contact_name);
            } else
                setChromeStorage('contactName2', message.msg_values.contact_name);

            StoreCalls.setLine(message.msg_values.line).searchByPhone(0).updateOrAddCall({name: message.msg_values.contact_name});
            chromeSend('phone', 'setProvider', {line: message.msg_values.line, contactName: message.msg_values.contact_name});
            
        } else if (message.msg_type == 'outgoing_calling_number' && message.msg_values.line == 1) {

            Base.providerNumber = message.msg_values.phone_num;
            setChromeStorage('providerNumber', message.msg_values.phone_num);
            chromeSend('phone', 'setProvider', {line: message.msg_values.line, providerNumber: message.msg_values.phone_num});

            setTimeout(() => {
                duration = 1;
                SendNotify.send('hungUp');
            }, 1000);

        } else if (message.msg_type == 'call') {

            let line = 1;
            Base.phoneNumber = message.msg_values.phone;
            let message_out = {
                invite: `sip:${Base.phoneNumber}@${line}`,
                makecallid: message.msg_values.makecallid
            }

            socketSend(message_out);
            callType = 'outgoing';
            startCall(Base.phoneNumber, line, 'outgoingByChromeExtIntegration');

            if (StoreCalls.setLine(line).searchByPhone(Base.phoneNumber).found) {
                StoreCalls.searchByPhone(Base.phoneNumber).updateOrAddCall({date: StoreCalls.getDate(), type: 'outgoing', success: false});
            } else {
                StoreCalls.searchByPhone(Base.phoneNumber).updateOrAddCall({phone: Base.phoneNumber, type: 'outgoing'});
            }
        } else if (message.msg_type == 'write' && message.msg_values.key == 'last_level') {
            setChromeStorage('last_level', message.msg_values.data);
        } else if (message.msg_type == 'myurl') {
            setChromeStorage('myurl', message.msg_values.url);
            console.log('myurl', message.msg_values.url);
        }

    };

    socket.onclose = () => {

	    wsStatus = 0;
        if (extentionPhoneStatus == 'on') {
            setTimeout(connectWebSocket, wsTimeot);
            setLogo('red');
        } else {
            setLogo('gray');
        }


        Base.setBadge('clear');
        clearStorage(1);
        clearStorage(2);
    };

    socket.onerror = (error) => {
        socketUrl = socketUrldef;
        SendNotify.close();
        console.error('WebSocket error:', error);
        socket.close();
    };
}

async function webrtcClose () {

    let phoneBackgroundClass = await getChromeStorage('phoneBackgroundClass');
    let phoneBackgroundClass2 = await getChromeStorage('phoneBackgroundClass2');

    if (phoneBackgroundClass == '' && phoneBackgroundClass2 == '') {
        chromeSend(audioval, 'closeWebRTC');
    
        socketSend({ "webrtc": "close" });
        Base.setBadge('clear');
    }
}

async function clearStorage (line = '1') {

    if (line == 1) {

        await setChromeStorage('phoneBackgroundClass', phoneBackgroundClass = '');
        await setChromeStorage('phoneNumber', '');
        await setChromeStorage('holdStatus', 'holdOff');
        await setChromeStorage('contactName', '');
        await setChromeStorage('providerNumber', '');

        chromeSend('phone', 'clearStatus', {line: line});
        chromeSend('phone', 'setProvider', {contactName: '',providerNumber: ''});
        
    } else if (line == 2) {
        await setChromeStorage('phoneNumber2', '');
        await setChromeStorage('phoneBackgroundClass2', phoneBackgroundClass = '');
        chromeSend('phone', 'clearStatus', {line: line});
    }

    Base.stopCountDuration();

}


chrome.runtime.onStartup.addListener(async () => {
    await loadDefaults();
    await checkConnection();
    await connectWebSocket();
    await Base.checkRuntimeMessages();
});

chrome.runtime.onInstalled.addListener(async () => {
    await loadDefaults();
    await checkConnection();
    await connectWebSocket();
    await Base.checkRuntimeMessages();
});




// Listener

chrome.runtime.onMessage.addListener(async (message, sender, sendResponse) => {

    if (message.target != 'background') return;

    if (message.command == 'sendOffer') {

        if (socket) {
            if (message.data.type == 'offer') {
                wait4sdp = false;
                let message_out = {
                    sdp: message.data.sdp,
                    type: message.data.type
                }
                socketSend(message_out);
                
            } else {
                socketSend(message.data);
            }
        }

        return;
    }
    
    setSessionStorage('logPopup2BackgoungMessages', 0);
    
    if (message.command == 'call') {
        let message_out = {
            invite: `sip:${message.data.phoneNumber}@${message.data.line}`,
            makecallid: ""
        }
        socketSend(message_out);

        if (StoreCalls.setLine(message.data.line).searchByPhone(message.data.phoneNumber).found) {
            StoreCalls.searchByPhone(message.data.phoneNumber).updateOrAddCall({date: StoreCalls.getDate(), type: 'outgoing', success: false});
        } else {
            StoreCalls.searchByPhone(message.data.phoneNumber).updateOrAddCall({phone: message.data.phoneNumber, type: 'outgoing'});
        }

        callType = 'outgoing';
        startCall(message.data.phoneNumber, message.data.line, callType);

    } else if (message.command === 'bye') {
        finishCall(message.data.line);

        SendNotify.close();
    } else if (message.command == 'acceptCall') {
        acceptCall();
    } else if (message.command == 'holdCall') {
        socketSend({"info":"on_hold","msg_values":{"line":"1"}});
    } else if (message.command == 'offHoldCall') {
        socketSend({"info":"off_hold","msg_values":{"line":"1"}});
    } else if (message.command == 'forwardCall') {

        socketSend({"info":"forward","msg_values":{"line":"2_1"}});

        Base.setBadge('clear');
        clearStorage(1);
        clearStorage(2).then(() => {
            webrtcClose();
        });
        SendNotify.close();
    } else if (message.command == 'setAutoAcceptCallStatus') {
        autoAcceptCallStatus = message.data.status;
    } else if (message.command == 'setRedirectCall') {

        redirectCallPhoneNumber = message.data.redirectCallPhoneNumber;
        redirectCallStatus = message.data.status;

        socketSend({
            "info": "just_callout",
            "msg_values": { "status": redirectCallStatus }
        });
    } else if (message.command == 'addInt2Number') {
        socketSend({"info":"sendDTMF","msg_values":{"line":message.data.number+"1"}});
    } else if (message.command == 'phoneOff') {
        extentionPhoneStatus = 'off';
        socketUrl = socketUrldef;
        socket.close();
        chromeSend(audioval, 'closeWindow');
    } else if (message.command == 'phoneOn' || message.command == 'token') {
        token = message.data?.token || token;
        extentionPhoneStatus = 'on';
        connectWebSocket();
        statcount = -1;
        checkConnection();
    } else if (message.command == 'logout') {
        token = '';
        extentionPhoneStatus = 'on';
        setChromeStorage('extentionPhoneStatus', 'on');
        setChromeStorage('token', '');
        setLogo('gray');
        if (socket) socket.close();
        chromeSend(audioval, 'closeWindow');
    } else if (message.command == 'changeUseNotification') {
        useNotification = message.data.status;
    } else if (message.command == 'clearShowLostLabel') {
        Base.setShowLostLabel(false);
        Base.setBadge('clear');
    } else if (message.command == 'selectAudioOutput') {
        chromeSend(audioval, 'selectAudioOutput', message.data);
    } else if (message.command == 'Restart') {
        Log.add(`command - Restart`, 'extension_reload');
        chrome.runtime.reload();
    }

});

const StoreCalls = {

    callsData: [],
    callsData2: [],
    currentLine: 1,

    async loadCallsData() {
        let data = await getChromeStorage('callsData');
        this.callsData = Array.isArray(data) ? data : [];
        data = await getChromeStorage('callsData2');
        this.callsData2 = Array.isArray(data) ? data : [];
        return this;
    },

    async saveCallsData() {
        if (this.currentLine == 1) {
            await setChromeStorage('callsData', this.callsData);
        } else {
            await setChromeStorage('callsData2', this.callsData2);
        }
        return this; 
    },

    setLine(line) {
        this.currentLine = line;
        return this; 
    },

    getDataSource() {
        return this.currentLine == 2 ? this.callsData2 : this.callsData;
    },

    searchByPhone(phone) {
        let index;
        const dataSource = this.getDataSource(); // Get the current data source based on the line
        if (phone === 0) {
            index = 0;            
        } else {
            index = dataSource.findIndex((call) => call.phone === phone);
        }
        const formattedDate = StoreCalls.getDate();
        const defaultCallStructure = {
            dateSort: new Date(),
            date: formattedDate,
            phone: '',
            name: 'Unknown',
            type: '',
            success: false
        };

        return {
            updateOrAddCall: (newData = {}) => {
                if (index >= 0 && index < dataSource.length) {
                    newData.dateSort = new Date();
                    dataSource[index] = { ...dataSource[index], ...newData };
                    this.sortByDate();
                } else {
                    const newEntry = {
                        ...defaultCallStructure,
                        phone,
                        ...newData,
                    };
                    dataSource.push(newEntry);

                    this.sortByDate().then(() => {
                        StoreCalls.removeOldest();
                    });
                }
                return this.saveCallsData();
            },
            found: index >= 0,
        };
    },

    getDate() {
        const now = new Date();
        const formattedDate = `${String(now.getDate()).padStart(2, '0')}/${String(now.getMonth() + 1).padStart(2, '0')} ${String(now.getHours()).padStart(2, '0')}:${String(now.getMinutes()).padStart(2, '0')}:${String(now.getSeconds()).padStart(2, '0')}`;
        return formattedDate;
    },

    async sortByDate() {
        return new Promise((resolve) => {
            const dataSource = this.getDataSource();
            dataSource.sort((a, b) => {
                const dateA = a.dateSort && !isNaN(new Date(a.dateSort)) ? new Date(a.dateSort) : null;
                const dateB = b.dateSort && !isNaN(new Date(b.dateSort)) ? new Date(b.dateSort) : null;
    
                if (dateA && dateB) {
                    return dateB - dateA;
                }
                if (!dateA && !dateB) {
                    return 0;
                }
                return dateA ? -1 : 1;
            });
        
            this.saveCallsData().then(() => {
                resolve(this);
            });
        });
    },

    removeOldest() {
        const dataSource = this.getDataSource();
        if (dataSource.length > 10) {
            dataSource.pop();
        }
        return this.saveCallsData();
    },
};


const SendNotify = {
    notificationId: null,
    title: '',
    message: '',
    notificationType: 'accept',
    line: 1,
    listenerRegistered: false,
    duration: duration,
    simulateProgressTimeout: false,

    send(notificationType) {

        if (useNotification === false || showprogress === false) return;

        if (!notificationType) {
            notificationType = this.notificationType || 'accept';
        } else {
            this.notificationType = notificationType;
        }

        let title = Base.phoneNumber;
        
        let iconUrl = notificationType === 'hungUp'
            ? chrome.runtime.getURL('assets/icons/call_red.png')
            : chrome.runtime.getURL('assets/icons/call_blue.png');

        let openNewIfCurrentDontExist = false;
        let message = '';
        if (Base.contactName.length > 40)
            message = Base.contactName.slice(0, 40) + '\nDuration: ' + Base.formatDuration(duration) + '\n' + Base.providerNumber + ' : ' + Base.providerName;
        else 
            message = Base.contactName + '\n\nDuration: ' + Base.formatDuration(duration) + '\n' + Base.providerNumber + ' : ' + Base.providerName;
        
        for (let j = 0; j < 2; j++) {

            if (this.notificationId === null) {

                chrome.notifications.create({
                    type: 'progress',
                    iconUrl: iconUrl,
                    title: 'Used : Tel ' + title,
                    message: message,
                    requireInteraction: true,
                    progress: duration
                }, (id) => {
                    this.notificationId = id;
                    if (this.simulateProgressTimeout === false) {
                        this.simulateProgressTimeout = true;
                        this.simulateProgress();
                    }
                });

            } else {
                    chrome.notifications.update(this.notificationId, {
                        progress: this.getProgressValue(),
                        requireInteraction: true,
                        message: message
                    }, (wasUpdated) => {
                        if (!wasUpdated) {
                            SendNotify.notificationId = null;
                            openNewIfCurrentDontExist = true;
                        }
                    });
                    
            }
            if (openNewIfCurrentDontExist == false) break;
        }
        
        if (!this.listenerRegistered) {
            chrome.notifications.onClicked.addListener((notificationId) => {
                if (notificationId === this.notificationId) {
                    this.close();
                    if (this.notificationType === 'accept') {
                        acceptCall();
                        this.close();
			            this.notificationType ='hungUp';
                        showprogress = true;
                    } else {
                        finishCall(this.line);
                        this.notificationId = null;
                        this.close();
                    }
                }
            });

            chrome.notifications.onClosed.addListener((notificationId, byUser) => {
                if (notificationId === this.notificationId) {
                    SendNotify.notificationId = null;
            	    if (showprogress) this.send();
                }
            });

            this.listenerRegistered = true;
        }
    },

    simulateProgress() {

        if (showprogress) {

            setTimeout(() => {
                this.send();
                this.simulateProgress();
            }, 1000); // Виконується через 1 секунди

        } else {
            this.simulateProgressTimeout = false;
        }
    },

    getProgressValue() {
        if (phoneBackgroundClass === 'green') return parseInt((duration * 100) / 3600)% 100;
        else return parseInt((duration * 100) / 120)% 100;
    },

    close() {
        duration = 0;
        showprogress = false;
        if (this.notificationId) {
            chrome.notifications.clear(this.notificationId, (wasCleared) => {
                if (wasCleared) {
                    this.notificationId = null;
                }
            });
        }
    }
};

const Base = {
    phoneNumber: '',
    contactName: '',
    providerNumber: '',
    providerName: '',
    showLostLabel: false,
    isDurationCounting: false,


    clearForCall () {
        this.phoneNumber = 'phoneNumber';
        this.contactName = 'contactName';
        this.providerNumber = 'Unknown provider';
        this.providerName = '';
    },

    setBadge (command = '') {

        if (command.toLowerCase() == 'call') {
            chrome.action.setBadgeText({ text: 'Call' });
            chrome.action.setBadgeBackgroundColor({ color: 'antiquewhite' });    
        } else if (this.showLostLabel == true) {
            chrome.action.setBadgeText({ text: 'Lost' });
            chrome.action.setBadgeBackgroundColor({ color: 'red' });
        } else if (command.toLowerCase() == 'clear' && phoneBackgroundClass == '') {
            chrome.action.setBadgeText({ text: '' });
        }

        return true;

    },
    setShowLostLabel (value) {
        setChromeStorage('showLostLabel', value);
        this.showLostLabel = value;
    },

    formatDate(type = '') {
        let date = '';
        
        const now = new Date();
        if (type != '') date = `${now.getFullYear()}-${String(now.getMonth() + 1).padStart(2, '0')}-${String(now.getDate()).padStart(2, '0')} `;
        return date + `${now.getHours().toString().padStart(2, '0')}:${now.getMinutes().toString().padStart(2, '0')}:${now.getSeconds().toString().padStart(2, '0')}.${now.getMilliseconds().toString().padStart(3, '0')}`;
    },

    startCountDuration (start = false) {
        
        if (start == true) this.isDurationCounting = true;
        else if (this.isDurationCounting == false) return;

        chromeSend('phone', 'updateCallDuration', {callDuration: this.formatDuration(duration)});
        duration += 1;
        setTimeout(() => {
            this.startCountDuration();
            
        }, 1000);
    },
    stopCountDuration () {
        this.isDurationCounting = false;
        duration = 0;
    },

    formatDuration(duration) {
        const minutes = Math.floor(duration / 60);
        const seconds = duration % 60;

        const formattedMinutes = String(minutes).padStart(2, '0');
        const formattedSeconds = String(seconds).padStart(2, '0');

        return `${formattedMinutes}:${formattedSeconds}`;
    },

    /**
     * related to Phone logRuntimeMessages()
     */
    async checkRuntimeMessages() {

        let res = await getSessionStorage('logPopup2BackgoungMessages');
        if (res > 2) {
            Log.add(`count messages = ${res}`, 'extension_reload');
            chrome.runtime.reload();
        }

        setTimeout(() => {
            Base.checkRuntimeMessages();
        }, 10000); // 10 sec
    }
}


const Log = {
    logs: [],


    print (...vars) {
        if (debugLevel) console.log(Base.formatDate(), ...vars);
    },

    async load(collection = null) {
        const storedLogs = await getChromeStorage('logs');
        this.logs = Array.isArray(storedLogs) ? storedLogs : [];
        
        if (collection) {
            return this.logs.filter(log => log.collection === collection);
        }
        
        return this.logs;
    },


    async save() {
        await setChromeStorage('logs', this.logs);
    },

    async add(entry, collection = 'default') {
        const maxLogs = 500;

        const logs = await this.load();

        const date = Base.formatDate('full');
        logs.push({ date, collection, entry });

        if (logs.length > maxLogs) {
            this.clear();
        }

        await this.save();
    },

    async clear() {
        this.logs = this.logs.slice(100, 600);
        await this.save();
    },

    async filterByType(type) {
        return this.load(type);
    },

    async listCollections() {
        const logs = await this.load();
        const uniqueCollections = [...new Set(logs.map(log => log.collection))];
        console.log('Available Collections:', uniqueCollections);
        return uniqueCollections;
    }
};

const Service = {
    async fetchData(params = {}, method = 'GET', headers = {}) {
        let url = 'https://lira2r.voip.com.ua/chrome_ext_integrations/index.php?route=getInfo';

        const options = {
            method,
            headers: { 'Accept': 'application/json', ...headers },
            credentials: 'include'
        };

        if (method === 'GET') {
            const queryString = new URLSearchParams(params).toString();
            url = `${url}${queryString ? '&' + queryString : ''}`;
        } else if (['POST', 'PUT', 'PATCH', 'DELETE'].includes(method)) {
            options.headers['Content-Type'] = 'application/json';
            options.body = JSON.stringify(params);
        } 

        try {
            const response = await fetch(url, options);
            if (!response.ok) throw new Error(`HTTP ${response.status}`);
            return await response.json();
        } catch (error) {
            console.error('❌ HTTP Error:', error);
            return null;
        }
    }
};

setTimeout(() => {
    
chrome.tabs.onUpdated.addListener(async (tabId, changeInfo, tab) => {
    if (changeInfo.status === 'complete' && /^https?:/.test(tab.url)) {

        const windowId = (parseInt(Math.random() * 1000000000).toString()) + Date.now();
        const loaderScriptUrl = chrome.runtime.getURL('js/loader.js');
        let scriptingWssUrl = await getChromeStorage('myurl');
        console.log('scriptingWssUrl1', scriptingWssUrl, socketUrl);
        if (token === null) {
            token = await getChromeStorage('token');
        }
        if (scriptingWssUrl === null || scriptingWssUrl === undefined) {
            scriptingWssUrl = socketUrl;
        }
        console.log('scriptingWssUrl2', scriptingWssUrl, socketUrl);


        let res = await Service.fetchData({token: token});
        scriptingDomain = res?.message?.integration_domain;

        console.log(scriptingDomain);
        const urlObj = new URL(tab.url);
        const domain = urlObj.hostname;

        const allowedDomains = [
            scriptingDomain
        ];
        
        if (!allowedDomains.includes(domain)) {
            return; // ❌ Не дозволений домен
        }

        chrome.scripting.executeScript({
            target: { tabId },
            func: (loaderUrl, param1Value, windowId, scriptingWssUrl) => {
                console.log('scripting scriptingWssUrl', scriptingWssUrl);
                const script = document.createElement('script');
                script.src = `${loaderUrl}?token=${encodeURIComponent(param1Value)}&windowId=${windowId}&socketUrl=${scriptingWssUrl}`;
                script.type = 'text/javascript';
                script.async = true;

                script.onload = () => console.log('✅ loader.js завантажено ' + script.src);
                script.onerror = () => console.error('❌ помилка завантаження loader.js');

                document.documentElement.appendChild(script);
            },
            args: [loaderScriptUrl, token, windowId, scriptingWssUrl]
        });
    }
});

}, 10000);
